/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.datagen.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    protected final String folderName;
    protected final CraftingBookCategory craftingBookCategory;
    protected final Item result;
    protected final int count;
    protected final List<String> rows = Lists.newArrayList();
    protected final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    protected final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    protected String group;
    protected boolean showNotification = true;

    public ShapedRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
        this.craftingBookCategory = craftingBookCategory;
        this.folderName = folderName;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ShapedRecipeBuilder shaped(ItemLike result) {
        return ShapedRecipeBuilder.shaped("crafting", result);
    }

    public static ShapedRecipeBuilder shaped(ItemLike result, int count) {
        return ShapedRecipeBuilder.shaped("crafting", result, count);
    }

    public static ShapedRecipeBuilder shaped(String folderName, ItemLike result) {
        return ShapedRecipeBuilder.shaped(folderName, result, 1);
    }

    public static ShapedRecipeBuilder shaped(String folderName, ItemLike result, int count) {
        return new ShapedRecipeBuilder(CraftingBookCategory.MISC, folderName, result, count);
    }

    public ShapedRecipeBuilder define(Character symbol, TagKey<Item> tag) {
        return this.define(symbol, Ingredient.m_204132_(tag));
    }

    public ShapedRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ShapedRecipeBuilder define(Character symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        return this;
    }

    public ShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public ShapedRecipeBuilder pattern(String ... pattern) {
        Arrays.stream(pattern).forEach(this::pattern);
        return this;
    }

    public ShapedRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public ShapedRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept((FinishedRecipe)new ShapedRecipeBuilder.Result(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.craftingBookCategory, this.rows, this.key, this.advancement, recipeId.m_246208_("recipes/" + this.folderName + "/"), this.showNotification));
    }

    public void m_176498_(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.m_126140_(finishedRecipeConsumer, RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_246208_(this.folderName + "/"));
    }

    public ShapedRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    protected final void ensureValid(ResourceLocation recipeId) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + recipeId + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String pattern : this.rows) {
            for (int i = 0; i < pattern.length(); ++i) {
                char symbol = pattern.charAt(i);
                if (!this.key.containsKey(Character.valueOf(symbol)) && symbol != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + recipeId + " uses undefined symbol '" + symbol + "'");
                }
                set.remove(Character.valueOf(symbol));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + recipeId);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + recipeId + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }
}

